<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">

                <div class="mt-2 mb-4">
                    <h1 class="title1 ">All Bookings</h1>
                </div>
                <x-danger-alert />

                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                <div class="mb-5 row">
                    <div class="col card p-3 shadow ">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <span style="margin:3px;">
                                <table id="ShipTable" class="table table-hover ">
                                    <thead>
                                        <tr>
                                            <th>Booking Type</th>
                                            <th>Client Name</th>
                                            <th>Celebrity Booked</th>
                                            <th>Purpose</th>
                                            <th>Payment method</th>
                                            <th>Membership card selected</th>
                                            <th>Date Created</th>

                                            <th>Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($bookings as $booking)
                                            <tr>
                                                <td>{{ $booking->booking_type }}</td>
                                                <td>{{ $booking->name }} </td>
                                                @if (isset($booking->celebrity->name) && $booking->celebrity->name != null)
                                                    <td>{{ $booking->celebrity->name }}</td>
                                                @else
                                                    <td>Celebrity deleted.</td>
                                                @endif

                                                <td>{{ $booking->purpose }}</td>
                                                <td>{{ $booking->method }}
                                                </td>
                                                <td>{{ $booking->membership_plan }}</td>
                                                <td>{{ \Carbon\Carbon::parse($booking->created_at)->toDayDateTimeString() }}
                                                </td>
                                                {{-- <td>
                                                    <a href="{{ route('Viewbooking', $booking->id) }}"
                                                        class="m-1 btn btn-info btn-sm"><i class="fa fa-eye"></i> Edit</a>
                                                </td> --}}


                                                <td>
                                                    <a href="{{ route('deletebooking', $booking->id) }}"
                                                        class="m-1 btn btn-danger btn-sm">Delete</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endsection
