@extends('layouts.base')
@section('title', $title)
@section('content')
    <header class="header">
        <nav class="mobile" id="mobile">
            <div class="top">
                <a href="/">
                    <h3 class="logo"> {{ $settings->site_name }}</h3>
                </a>
            </div>
            <ul class="list">
                <li><a href="/">Home</a></li>
                <li><a href="membership.html">Apply For Vip Fan Card</a></li>
                <li><a href="greet.html">Book and Greet Session </a></li>
            </ul>
        </nav>

        <nav class="desktop book">
            <a href="/">
                <h3 class="logo"> {{ $settings->site_name }}</h3>
            </a>
            <ul class="list">
                <li><a href="/">Home</a></li>
                <li><a href="book_celebrity">Apply For Vip Fan Card</a></li>
                <li><a href="book_celebrity">Book and Greet Session </a></li>
            </ul>
        </nav>
    </header>
    <main class="main">
        <section class="section cards">
            <div class="wrapper">
                <div class="title-box">
                    <h3 class="heading">All Celebrities</h3>
                </div>
                <div class="boxes  px-1">
                    @foreach ($celebrities as $celebrity)
                        <div class="box mx-2 ">


                            <img src="{{ asset('storage/app/public/' . $celebrity->photo) }}" alt="image">
                            <div class="text">
                                <h3 class="heading">Name: {{ $celebrity->name }} </h3>
                                <h3 class="heading">Country: {{ ucfirst($celebrity->country) }} </h3><a
                                    href='{{ route('book_celebrity_now', $celebrity->id) }}'><button>Book
                                        Now</button></a><a href='{{ route('donate', $celebrity->id) }}'><button>Donate
                                        to charity
                                        foundation</button></a><a
                                    href='{{ route('membership_card', $celebrity->id) }}'><button>Apply for fan
                                        membership
                                        card</button></a>
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </section>
    </main>

@endsection
