@extends('layouts.base')
@section('title', $title)
@section('content')

    <section class="section auth">

        <div class="wrapper">

            <div class="title-box">

                <h3 class="heading"> {{ $settings->site_name }}</h3>
                <p class="paragraph">BOOKNG FORM</p>
            </div>
            <div class="boxes">
                <div class="box">
                    @if (Session::has('success'))
                        <div
                            style="background-color: #4CAF50; color: #fff; padding: 10px; text-align: center; margin : 10px 0;">
                            {{ Session::get('success') }}
                        </div>
                    @endif

                    @if (Session::has('error'))
                        <div style="background-color: red; color: #fff; padding: 10px; text-align: center; margin : 10px 0;">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    <form action="{{ route('bookingstore') }}" class="form" method="POST">
                        @csrf
                        <div class="label-col">
                            <label for="#"> Full Name
                                <input type="text" placeholder="Fullname" name="name" required>
                                <p>
                                    @error('name')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>


                        </div>

                        <div class="label-row">
                            <label for="#">Phone Number
                                <input type="text" placeholder="Phone Number" name="phone" required>
                                <p>
                                    @error('phone')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>

                            <label for="#">Email
                                <input type="email" placeholder="Email" name="email" required>

                                <p>
                                    @error('email')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>
                        </div>



                        <div class="label-row">
                            <label for="#">gender

                                <select type="text" placeholder="Gender" name="sex" required>
                                    <option value='male'>
                                        Male
                                    </option>
                                    <option value='female'>
                                        Female
                                    </option>
                                </select>

                                <p>
                                    @error('gender')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>

                            <label for="#">Full Address
                                <input type="text" placeholder="Full Address" name="address" required>

                                <p>
                                    @error('address')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>
                        </div>
                        <div class="column-row">
                            <label for="#">Celebrity Name
                                <input type="text" placeholder="Celebrity Name" value="{{ $celebrity->name }}"
                                    name="celebrity" required readonly>
                            </label>


                        </div>
                        <div class="label-col">

                            <input type="hidden" value="{{ $celebrity->id }}" placeholder="Celebrity Name"
                                name="celebrity_id" required>

                            <input type="hidden" value="Celebrity Booking" placeholder="Celebrity Name"
                                name=" booking_type" required>


                            <label for="#">Purpose of Booking
                                <textarea name="purpose" cols="52" rows="7" required></textarea>

                                <p>
                                    @error('purpose')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                </p>
                            </label>

                        </div>

                        <label for="#">
                            {{-- <span class="label-row">
                                <input required type="checkbox" name="check" id="check">
                                <p class="paragraph">By clicking this form you agree to all <a href="index-2.html">Terms &
                                        conditions</a></p>
                            </span> --}}
                        </label>

                        <label for="#"><button name="book">Submit</button></label>
                    </form>
                </div>
            </div>
        </div>
    </section>


@endsection
