<?php

use App\Http\Controllers\Admin\ClearCacheController;
use Illuminate\Support\Facades\Route;
use App\Models\Settings;
use Laravel\Fortify\Http\Controllers\NewPasswordController;
use App\Http\Controllers\AutoTaskController;
use App\Http\Controllers\HomePageController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__ . '/admin/web.php';
require __DIR__ . '/user/web.php';
require __DIR__ . '/botman.php';



//cron url
Route::get('/cron', [AutoTaskController::class, 'autotopup'])->name('cron');
//Front Pages Route
Route::get('/', [HomePageController::class, 'index'])->name('home');
Route::get('book_celebrity', [HomePageController::class, 'book'])->name('book');
Route::get('book_celebrity_now/{id}', [HomePageController::class, 'book_celebrity_now'])->name('book_celebrity_now');
Route::get('membership_card/{id}', [HomePageController::class, 'membership_card'])->name('membership_card');
Route::get('donate/{id}', [HomePageController::class, 'donate'])->name('donate');
Route::post('bookingstore', [HomePageController::class, 'bookingstore'])->name('bookingstore');
Route::post('donate_store', [HomePageController::class, 'donate_store'])->name('donate_store');
Route::post('apply_membership_card', [HomePageController::class, 'apply_membership_card'])->name('apply_membership_card');
Route::post('loan_application', [HomePageController::class, 'loan_application'])->name('loan_application');


Route::post('sendcontact', 'App\Http\Controllers\User\UsersController@sendcontact')->name('enquiry');
